## Introduction to Prefilter Policies

- Traffic arriving at a Cisco Secure Firewall Threat Defense device is processed by the ASA and Snort engines.
- A prefilter policy serves as the initial defense line within the ASA engine, protecting against undesired traffic.

## Reasons to Use Prefilter Policies

- **Performance Improvement**:
    
    - Blocks or exempts traffic early, enhancing system performance.
    - Operates based on Layer 3 and Layer 4 conditions.
- **Inspection for Tunneled Traffic**:
    
    - Inspects tunneled traffic using tunnel endpoints, IP addresses, and encapsulation types.
    - Acts on outer headers for non-encrypted tunneled traffic.
    - Supports tunneling types like GRE, IP in IP, IPv6 in IP, and Teredo.

## Prefilter Policy Structure

- **Rule Evaluation**:
    - Rules are evaluated using a top-bottom approach.
    - Each rule includes conditions and associated actions.

### Conditions for Rules

- **Prefilter Rules**:
    - Match based on security zones, source and destination IP addresses, VLAN, protocols, or ports.

- **Tunnel Rules**:
    - Match based on security zones, tunnel endpoints, VLAN, encapsulation type, or port.

### Actions for Prefilter Rules

- **Block**: Discards traffic immediately without inspection.
- **Fastpath**: Permits traffic without Snort inspection; eligible for flow offload on certain platforms.
- **Analyze**: Sends traffic for further inspection based on ACP rules.

## Prefilter Policy Processing Sequence

- Prefilter rules are applied within the ASA engine.
- Rules match traffic based on Layer 3 and Layer 4 conditions.
- Matched rules determine whether traffic is discarded, inspected by Snort, or sent to the next steps.

## Prefilter Policies Use Case Example

### Policy Rules Configuration

1. **First Rule**:
    
    - Blocks Telnet traffic from InZone to DmzZone, based on destination TCP port (TCP port 23).
2. **Second Rule**:
    
    - Allows voice traffic from InZone to DmzZone, based on destination UDP ports.
    - Traffic is fastpathed, bypassing Snort inspections.
3. **Third Rule**:
    
    - Matches GRE traffic and sends it for further analysis to ACP for inner header inspection.
4. **Fourth Rule**:
    
    - Immediately blocks Teredo IPv6 tunnels.

### Default Action for Non-matching Traffic

- Non-tunnel traffic not matching prefilter rules is sent to ACP for inspection.
- Tunnel traffic default action can be set to analyze or block all remaining tunnel traffic.

## Application of Prefilter Policies

- Prefilter policies are applied to an Access Control Policy (ACP), which is then applied to a Threat Defense device.
- Users can change the applied prefilter policy by selecting from available options.